' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

''' <summary>
''' Klasa MemberManager jest uywana do przydzielania czonkw zespou do aplikacji oraz cofania przydziau.
''' </summary>
Public Class MemberManager

#Region "Konstruktor(y)"

  Private Sub New()
  ' Ukryj konstruktor, poniewa ta klasa ma wycznie skadniki o dostpie wspdzielonym.
  End Sub

#End Region

  ''' <summary>
  ''' Przydziela czonkw zepou do danej aplikacji.
  ''' </summary>
  ''' <param name="memberId">Identyfikator czlonka zespou w bazie danych.</param>
  ''' <param name="applicationId">Identyfikator aplikacji w bazie danych.</param>
  Public Shared Sub AssignMemberToApplication(ByVal memberId As Guid, ByVal applicationId As Integer)
    ChangeMemberApplicationBinding(memberId, applicationId, True)
  End Sub

  ''' <summary>
  ''' Odsuwa czonka zespou od danej aplikacji.
  ''' </summary>
  ''' <param name="memberId">Identyfikator czlonka zespou w bazie danych.</param>
  ''' <param name="applicationId">Identyfikator aplikacji w bazie danych.</param>
  Public Shared Sub UnAssignMemberFromApplication(ByVal memberId As Guid, ByVal applicationId As Integer)
    ChangeMemberApplicationBinding(memberId, applicationId, False)
  End Sub

  ''' <summary>
  ''' Przydziela lub cofa przydzia czonka zespou do aplikacji.
  ''' </summary>
  ''' <param name="memberId">Identyfikator czlonka zespou w bazie danych.</param>
  ''' <param name="applicationId">Identyfikator aplikacji w bazie danych.</param>
  ''' <param name="mustAssign">Okrela czy czonek zespou ma byc przydzielony do aplikacji (True) czy te odsunity (False).</param>
  Private Shared Sub ChangeMemberApplicationBinding(ByVal memberId As Guid, ByVal applicationId As Integer, ByVal mustAssign As Boolean)
    MemberManagerDB.ChangeMemberApplicationBinding(memberId, applicationId, mustAssign)
  End Sub
End Class
